local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local theBeginning = '2.75x,*99 no mini,*99 overhead,*99 no reverse,*99 125% beat'
		
		local ohbaOn = '*8 invert'
		local ohbaOff = '*8 no invert'

		local idk = '*30 200% drunk'
		local idkNeg = '*30 -200% drunk'
		local idkOff = '*40 no drunk'

		local goDown = '*6 200% centered'
		local restorePosition = '*99 no centered'

		local downSection = '*2 reverse'
		local downSectionB = '*2 split'
		local downSectionoff = '*2 no reverse,*2 no split'

		local hit8th = '*99 -200% tiny,*99 hallway'
		local hit8thOff = '*15 no tiny,*15 overhead'

		local hit16th = '*99 150% mini'
		local hit16thOff = '*99 no mini'

		local tipy = '*30 150% tipsy'
		local tipyNeg = '*30 -150% tipsy'
		local tipyOff = '*40 no tipsy'
		
		local minOn = '*6 150% mini'
		local minOff = '*6 no mini'
		local minOffX2 = '*50 no mini'
		
		local hardMini = function(percent)
			return '*99 ' .. percent .. '% mini'
		end

		mods = {
			{0, theBeginning},
			{47.1, '*50 -200% mini,*50 stealth'},
			{51.1, '*99 no mini,*99 no stealth'},
			{79.51, '*99 2000% dizzy'},
			{81.1, '*99 no dizzy'},
			{97.1, '*10 flip'},
			{97.5, '*10 -100% invert'},
			{98, '*10 no flip,*99 invert'},
			{98.5, '*10 no invert'},
			{99, '*4 flip'},
			{100, '*99 no beat,*99 no flip'},
			{102, downSection},
			{106, downSectionoff},
			{110, downSectionB},
			{114, downSectionoff},
			{120, '*99 flip,*99 -100% invert'},
			{120.5, '*99 no flip,*99 no invert'},
			{152, restorePosition},
			{240, '*99 -150% beat'},
			{279, '*6 200% mini'}
		}
		
ohbas={{3, 3.5},{7, 7.5},{11, 11.5},{14, 14.5},{15, 15.5},{19, 19.5},{23, 23.5},{27, 27.5},{30, 30.5},{31, 31.5}}

for i,v in pairs(ohbas) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, ohbaOn})
		table.insert(mods, {beat + 0.5, ohbaOff})
    end
end

idks={{32,36},{40,44},{52,56},{60,64},{68,72},{76,80},{84,96}}

for i,v in pairs(idks) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, idk})
		table.insert(mods, {beat + 0.25, idkNeg})
		table.insert(mods, {beat + 0.5, idk})
		table.insert(mods, {beat + 0.75, idkNeg})
		table.insert(mods, {beat + 1, idkOff})
    end
end

for beat=122,135, 2 do
	table.insert(mods, {beat, '*4 flip,*4 -100% invert'})
	table.insert(mods, {beat + 0.5, '*4 no flip,*4 no invert'})
end

for beat=136,151, 1 do
	table.insert(mods, {beat + 0.25, goDown})
	table.insert(mods, {beat, restorePosition})
end

for beat=152,159, 1 do
	table.insert(mods, {beat, hit8th})
	table.insert(mods, {beat + 0.25, hit8thOff})
	table.insert(mods, {beat + 0.5, hit8th})
	table.insert(mods, {beat + 0.75, hit8thOff})
end

for beat=160,165, 1 do
	table.insert(mods, {beat, hit16thOff})
	table.insert(mods, {beat + 0.25, hit16th})
	table.insert(mods, {beat + 0.5, hit16thOff})
	table.insert(mods, {beat + 0.75, hit16th})
	table.insert(mods, {beat + 1, hit16thOff})
end

tipes={{183.1, 186.1},{199.1, 200.1},{220.1, 223.1}}

for i,v in pairs(tipes) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat, tipy})
		table.insert(mods, {beat + 0.25, tipyNeg})
		table.insert(mods, {beat + 0.5, tipy})
		table.insert(mods, {beat + 0.75, tipyNeg})
		table.insert(mods, {beat + 1, tipyOff})
    end
end

Boomboom={{171,174},{179,182},{187,190},{195,198},{208,211},{216,219},{224,227},{232, 235}}

for i,v in pairs(Boomboom) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat + 0.25, goDown})
		table.insert(mods, {beat, restorePosition})
		table.insert(mods, {beat + 2.99, restorePosition})
    end
end

bodymoves={{211,212},{219,220},{227,228},{235,236}}

for i,v in pairs(bodymoves) do
    for beat=v[1],v[2] do
        table.insert(mods, {beat + 0.01, '*99 2000% dizzy'})
		table.insert(mods, {beat + 0.5, '*9999 no dizzy'})
    end
end

for beat=236.1,239.1, 1 do
	table.insert(mods, {beat, minOn})
	table.insert(mods, {beat + 0.333, minOff})
	table.insert(mods, {beat + 0.667, minOn})
	table.insert(mods, {beat + 1, minOff})
end

for beat=252,254, 1 do
	table.insert(mods, {beat, idk})
	table.insert(mods, {beat + 0.333, idkNeg})
	table.insert(mods, {beat + 0.667, idk})
	table.insert(mods, {beat + 1, idkOff})
end

for beat=264,265, 1 do
	table.insert(mods, {beat, hardMini(-50)})
	table.insert(mods, {beat + 0.333, minOffX2})
	table.insert(mods, {beat + 0.667, hardMini(-50)})
	table.insert(mods, {beat + 1, minOffX2})
end

		local screenVibb = function()
			screen:vibrate():effectmagnitude(40, 40, 40)
		end

		local stopEffect = function()
			p1:stopeffect()
			p2:stopeffect()
			screen:stopeffect()
		end

		local yeah = function()
			for i=1, #players do
				players[i]
					:smooth(0.05)
					:skewx(1)
			end
		end

		local yeah2 = function()
			for i=1, #players do
				players[i]
					:smooth(0.05)
					:skewx(-1)
			end
		end

		local yeahRst = function()
			for i=1, #players do
				players[i]
					:skewx(0)
			end
		end

		actorCmds = {
			{68, function()
				for i=1, #players do
					players[i]
						:bob()
						:effectmagnitude(0, 100, 0)
						:effectclock('beat')
				end
			end},
			{83, stopEffect},
			{152, function()
				for i=1, #players do
					players[i]
						:bounce()
						:effectmagnitude(0, -50, 0)
						:effectclock('beat')
						:effectperiod(0.5)
				end
			end},
			{160, stopEffect}
		}
		
skewey={{175,178},{191,194},{212,215},{228,231}}

for i,v in pairs(skewey) do
    for beat=v[1],v[2] do
        table.insert(actorCmds, {beat, yeah})
        table.insert(actorCmds, {beat + 0.5, yeah2})
		table.insert(actorCmds, {beat + 3, yeahRst})
    end
end

Boomvibb={{171,174},{179,182},{187,190},{195,198},{208,211},{216,219},{224,227},{232, 235}}

for i,v in pairs(Boomvibb) do
    for beat=v[1],v[2] do
        table.insert(actorCmds, {beat, screenVibb})
        table.insert(actorCmds, {beat + 0.75, stopEffect})
    end
end

		-- for edit mode
		-- for i=#mods, 1, -1 do
		-- 	if GAMESTATE:GetSongBeat() > mods[i][1] then
		-- 		table.remove(mods, i)
		-- 	end
		-- end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end
			
			for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
                SCREENMAN:GetTopScreen():GetChild('ScoreP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('BPMDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('StageDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('SongTitle'):visible(false);
				SCREENMAN:GetTopScreen():GetChild("SongMeterDisplay" .. PlayerNumberToString(i-1)):visible(false);
				SCREENMAN:GetTopScreen():GetChild("StepsDisplay" .. PlayerNumberToString(i-1)):visible(false);
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,
	
	Def.Sprite{
    InitCommand= cmd(hibernate,74.673),
    OnCommand= cmd(x,-10000;y,-10000;sleep,0;zoom,1.2;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-199;rotationz,-45;linear,0.599;rotationz,135;addy,500;sleep,0;y,1000),
    Texture= "bass1.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,74.673),
    OnCommand= cmd(x,-10000;y,-10000;sleep,0;zoom,1.2;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-199;rotationz,45;linear,0.599;rotationz,-135;addy,500;sleep,0;y,1000),
    Texture= "bass2.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,74.673),
    OnCommand= cmd(x,-10000;y,-10000;sleep,0;zoom,1.2;x,SCREEN_WIDTH/4;y,SCREEN_CENTER_Y-199;rotationz,-45;linear,0.599;rotationz,135;addy,500;sleep,0;y,1000),
    Texture= "bass1.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,74.673),
    OnCommand= cmd(x,-10000;y,-10000;sleep,0;zoom,1.2;x,SCREEN_WIDTH/4;y,SCREEN_CENTER_Y-199;rotationz,45;linear,0.599;rotationz,-135;addy,500;sleep,0;y,1000),
    Texture= "bass2.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,74.673),
    OnCommand= cmd(x,-10000;y,-10000;sleep,0;zoom,1.2;x,SCREEN_WIDTH*3/4;y,SCREEN_CENTER_Y-199;rotationz,-45;linear,0.599;rotationz,135;addy,500;sleep,0;y,1000),
    Texture= "bass1.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,74.673),
    OnCommand= cmd(x,-10000;y,-10000;sleep,0;zoom,1.2;x,SCREEN_WIDTH*3/4;y,SCREEN_CENTER_Y-199;rotationz,45;linear,0.599;rotationz,-135;addy,500;sleep,0;y,1000),
    Texture= "bass2.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,116.3),
    OnCommand= cmd(x,-10000;y,-10000;zoom,0.4;sleep,0;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-199;rotationz,-45;linear,0.599;rotationz,135;addy,500;sleep,0;y,1000),
    Texture= "quack.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,116.3),
    OnCommand= cmd(x,-10000;y,-10000;zoom,0.4;sleep,0;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-199;rotationz,45;linear,0.599;rotationz,-135;addy,500;sleep,0;y,1000),
    Texture= "quack.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,116.3),
    OnCommand= cmd(x,-10000;y,-10000;zoom,0.4;sleep,0;x,SCREEN_WIDTH/4;y,SCREEN_CENTER_Y-199;rotationz,-45;linear,0.599;rotationz,135;addy,500;sleep,0;y,1000),
    Texture= "quack.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,116.3),
    OnCommand= cmd(x,-10000;y,-10000;zoom,0.4;sleep,0;x,SCREEN_WIDTH/4;y,SCREEN_CENTER_Y-199;rotationz,45;linear,0.599;rotationz,-135;addy,500;sleep,0;y,1000),
    Texture= "quack.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,116.3),
    OnCommand= cmd(x,-10000;y,-10000;zoom,0.4;sleep,0;x,SCREEN_WIDTH*3/4;y,SCREEN_CENTER_Y-199;rotationz,-45;linear,0.599;rotationz,135;addy,500;sleep,0;y,1000),
    Texture= "quack.png",
  },
  
	Def.Sprite{
    InitCommand= cmd(hibernate,116.3),
    OnCommand= cmd(x,-10000;y,-10000;zoom,0.4;sleep,0;x,SCREEN_WIDTH*3/4;y,SCREEN_CENTER_Y-199;rotationz,45;linear,0.599;rotationz,-135;addy,500;sleep,0;y,1000),
    Texture= "quack.png",
  },

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
}
